module printCharList

//********************************************************************************
//  Clean tutorial example program.
//
//  This program demonstrates the use of the function "printText1".
//  It instantiates the CharStreams class with the ListCharStream type. Objects
//  of type ListCharstream contain a list of characters, which should be printed.
//
//********************************************************************************

import StdEnv, StdPrintText

:: *ListCharStream = { list :: [Char] , savedPos :: [Char] }

instance CharStreams ListCharStream
  where
    getChar sc=:{list}
        # empty = isEmpty list
        = ( not empty, if empty ' ' (hd list),
            { sc & list=if empty list (tl list) })
    savePos sc
        = { sc & savedPos=sc.list }
    restorePos sc
        = { sc & list=sc.savedPos }
    eos sc=:{list}
        = (isEmpty list,sc)

fontDef = { fName="Courier New", fStyles=[], fSize=12 }

Start world
	# (defaultPS, world)	= defaultPrintSetup world
	= snd (accFiles	(printText1 True NoWrap fontDef 4
	       		                { list=['Hello printer'], savedPos=[] }
	            		        defaultPS)
            		world)
